<?php

class TuraController extends Controller
{
	public $layout = 'administration';
	public $defaultAction = 'admin';

	public function init()
	{
		Yii::import('application.modules.administration.controllers.MainController');
		$mainController = new MainController('main');
		$this->menu = $mainController->getMenu();
	}

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'accessControl',
			'postOnly + delete',
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow', // allow authenticated users to perform actions
				'actions'=>array('create','update','admin','view','delete','ajaxGetNextNumerTury'),
				'roles'=>array('admin', 'schoolAdmin')
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view', array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
		$classese = Yii::app()->user->getState('classes');
		$classesForSchoolAdmin = Yii::app()->user->role == 'schoolAdmin' && !empty($classese) ? Yii::app()->user->getState('classes') : array();

		$criteria = new CDbCriteria();
		$criteria->addInCondition(Yii::app()->db->quoteTableName('t').'.'.Yii::app()->db->quoteColumnName('id'), $classesForSchoolAdmin);
		$klasyModel = Klasa::model()->findAll($criteria);
		$klasy = array();
		$i = 0;
		foreach($klasyModel as $index=>$klasa)
		{
			if($klasa->czyTestowa != 1)
			{
				$klasy[$i]['id'] = $klasa->id;
				$klasy[$i]['nazwa'] = $klasa->nazwa . ' - '.$klasa->szkola->nazwa;
				$i++;
			}
		}

		$model = new Tura('insert');

		$model->czasRozpoczecia = date('d-m-Y H:i:s',time());
		$model->czasZakonczenia = date('d-m-Y H:i:s',time() + ParametryGry::getInt('CZAS_TRWANIA_LEKCJI', 49) * 60);

		if(isset($_POST['Tura']))
		{
			$model->attributes = $_POST['Tura'];

			if($model->save())
				$this->redirect(array('admin', 'id'=>$model->id));
		}
		$this->render('create', array(
			'model'=>$model,
			'klasy'=>$klasy,
		));
	}

	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{
		$model = $this->loadModel($id);

		if(isset($_POST['Tura']))
		{
			$model->attributes = $_POST['Tura'];

			if($model->save())
				$this->redirect(array('admin', 'id'=>$model->id));
		}

		$this->render('update',array(
			'model'=>$model,
			'klasy'=>Klasa::model()->findAll(),
		));
	}

	/**
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		$model = $this->loadModel($id);
		try
		{
			$model->delete();
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		catch(Exception $e)
		{
			throw new CHttpException(404, 'Nie można usunąć rekordu. Obiekt może być nierozerwalnie połączony z innymi elementami w bazie.');
		}
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
		$model = new Tura('search');
		$model->unsetAttributes();
		$model->dbCriteria->order='"czasRozpoczecia" DESC';
		$model->dbCriteria->addCondition('"idKlasy0"."czyTestowa" != 1');

		if(isset($_GET['Tura']))
			$model->attributes = $_GET['Tura'];

		$this->render('admin', array(
			'model'=>$model,
		));
	}

	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer $id the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model = Tura::model()->findByPk($id);

		if($model === null)
			throw new CHttpException(404, Yii::t('The requested page does not exist.'));

		$classese = Yii::app()->user->getState('classes');
		if(Yii::app()->user->role == 'schoolAdmin' && !empty($classese) && !in_array($model->idKlasy, Yii::app()->user->getState('classes')))
			throw new CHttpException(403, 'Nie jesteś upoważniony do wykonania tej akcji.');

		return $model;
	}

	public function actionAjaxGetNextNumerTury()
	{
		if(isset($_GET['classId']) && !empty($_GET['classId']))
		{
			$id = $_GET['classId'];
			$idLekcji = Yii::app()->db->createCommand('select max("idLekcji") from "Tura" where "idKlasy"='.$id)->queryScalar();

			if($idLekcji == '')
				$idLekcji = 1;
			else if($idLekcji < ParametryGry::getInt('ILOSC_AKTYWNYCH_LEKCJI', 15))
				$idLekcji++;

			echo $idLekcji;
		}
	}
}
